#version 3.7;

#declare RAD = 4;
                
global_settings {
        assumed_gamma 1
        max_trace_level 5
        noise_generator 2 
        radiosity {
                pretrace_start 0.08
                pretrace_end 0.04/RAD
                count 30*RAD                
                nearest_count min (20, RAD)      
                error_bound 2/RAD
                low_error_factor 0.5      
                recursion_limit 1      
                gray_threshold 0  
                minimum_reuse 0.015 
                brightness 0.25      
                adc_bailout 0.005
                normal on
                media on                         
        }
} 

#include "stdinc.inc"  

#declare fac = 1.27;

sky_sphere {
        pigment {
                average
                pigment_map {
                        [1      function {max (min (y, 1), 0)} 
                                color_map {
                                        [0      rgb fac*2.35]
                                        [0.96   rgb fac*4.5]
                                        [1      rgb fac*13.5]
                                }
                        ]
                        [1      function {max (min (y, 1), 0)}
                                turbulence 0.2
                                color_map {
                                        [0      rgbt 1]
                                        [0.5    rgbt <fac,fac,fac,1>]
                                }
                                rotate z*-45
                        ]
                }
        }
        rotate <50,0,0>
}

light_source {
        <0,50000,-50000>,
        color rgb 2 
}

#macro Porcelain (C_Porcelain)

#local P_Porcelain = pigment {color srgb C_Porcelain}

#local N_Porcelain =
normal {
	average
	normal_map {
		[1      bozo 0.633 scale 0.5]
		[1      bozo 0.633]
		[1      bozo 0.633 scale 2]
	}
} 

#local F_Porcelain =
finish {
	ambient 0
	diffuse 0.62
	brilliance 0.8
	reflection {0.1, 0.3 fresnel on}
	conserve_energy
}

#local T_Porcelain =
texture {
	pigment {P_Porcelain}
	normal {N_Porcelain}
	finish {F_Porcelain}
}

#local I_Porcelain = interior {ior 1.53}

material {
        texture {T_Porcelain}
        interior {I_Porcelain}
        scale 0.5
}

#end

plane {y, 0 Porcelain (<1,1,1>*0.87)}

camera {
        perspective
        up <0,1,0>
        right x*image_width/image_height
        location <0,9,25>
        look_at <-0.5,5.5,0> 
        angle 68
}

//==================================================

#declare p_map1 = pigment {image_map {png "leaf_c" gamma 2.2 interpolate 2}}
#declare p_map2 = normal {bump_map {png "leaf_b" gamma 2.2 interpolate 2}}
#declare p_map3 = pigment {image_map {png "leaf_a" gamma 1 interpolate 2}} 

//================================================== 

#declare T1 = 
texture {
        pigment {p_map1}
        finish {specular 0.3 roughness 0.003 diffuse 0.9 ambient 0}
        normal {p_map2 bump_size 1}
}

#declare T2 = texture {pigment {color rgbt <0,0,0,1>}} 

#declare di_normal =
material {
         texture { 
                 pigment_pattern {p_map3}
                 texture_map {
                        [0      T2]
                        [1      T1]
                 }
        }
} 

// no double_illuminate ____________________________________________________________________________

union {
	triangle {0, y, x+y}
	triangle {0, x, x+y}
        hollow
	material {di_normal}
	translate <-0.5,0,0>
	scale 14
        rotate <0,10,0>
	translate <10,0,0>
}

text {
        ttf "cyrvetic.ttf" concat ("no double_illuminate") 0, 0 
        scale 0.7
        rotate <0,180,0>
        translate <12,0.2,4>
        texture {
                pigment {color rgb x}
                finish {ambient 0 diffuse 0.5 emission 0.9}
        }
}

// normal double_illuminate ____________________________________________________________________________

union {
	triangle {0, y, x+y}
	triangle {0, x, x+y}
        double_illuminate hollow
	material {di_normal}
	translate <-0.5,0,0>
	scale 14
        rotate <0,30,0>
	translate <0,0,0>
} 

text {
        ttf "cyrvetic.ttf" concat ("double_illuminate") 0, 0 
        scale 0.7
        rotate <0,180,0>
        translate <2,0.2,4>
        texture {
                pigment {color rgb x}
                finish {ambient 0 diffuse 0.5 emission 0.9}
        }
}

// double_illuminate plus workaround ____________________________________________________________________________


union {
	triangle {0, y, x+y}
	triangle {0, x, x+y}
        double_illuminate hollow
	material {di_normal}
	translate <-0.5,0,0>
	scale 14
        rotate <0,50,0>
	translate <-11,0,0>
}

#declare T1 = 
texture {
        pigment {p_map1}
        finish {specular 0.3 roughness 0.003 diffuse 0.9 ambient 0}
        normal {p_map2 bump_size 1}
}

#declare T2 = 
texture {
        pigment {color rgbt <0,0,0,1>} 
        finish {ambient 0}
} 

// faked translucency mapping by adding another partly transparent object between light and object

#declare p_map4 = pigment {image_map {png "leaf_tl" gamma 1 interpolate 2}}
 
#declare di_workaround =
material {
         texture { 
                 pigment_pattern {p_map4}
                 texture_map {
                        [0      T1]
                        [1      T2]
                 }
        }
} 

union {
	triangle {0, y, x+y}
	triangle {0, x, x+y}
        hollow
	material {di_workaround}
	translate <-0.5,0,0>
	scale 14
        rotate <0,50,0>
	translate <-11,0,0.01> // slightly translated - you have to try out minimum distance
}

text {
        ttf "cyrvetic.ttf" concat ("faked translucency mapping") 0, 0 
        scale 0.7
        rotate <0,180,0>
        translate <-6,0.2,4>
        texture {
                pigment {color rgb x}
                finish {ambient 0 diffuse 0.5 emission 0.9}
        }
}